package jpattern.pattern;

//  Type used to record result of pattern match
public class MatchResult
{
    // Return the (possibly modified) subject string
    // The only time it changes is if replacements are done
    public String Subject;

    //  Starting index position(0 origin) of matched section of
    //  subject string. Only valid if Var is non-null.
    public int Start;

    //  Ending index position(0 origin) of matched section of
    //  subject string. Only valid if Var is non-null.
    public int Stop;

    public MatchResult(String Subject, int Start, int Stop)
	{this(); set(Subject); set(Start,Stop);}

    public MatchResult() {}

    public void set(String Subject) {this.Subject = Subject;}

    public void set(int Start, int Stop)
    {
	this.Start = Start;
	this.Stop = Stop;
    }

    public String Replace(String repl)
    {
	String prefix = Subject.substring(0,Start);
	String suffix = Subject.substring(Stop,Subject.length());
	return prefix+repl+suffix;
    }

    public String Match()
    {
	return Subject.substring(Start,Stop);
    }

    public String toString()
    {
	return String.format("MatchResult(%d,%d,|%s|)",
			     Start,
			     Stop,
			     (Subject==null?"null":Subject));
    }
}
