package jpattern.pattern;

import jpattern.pattern.Variable;

import java.util.HashMap;
import java.util.Collection;
import java.util.Iterator;

public class VarMap extends HashMap
{
    public VarMap() {super();}

    // Pure set/get
    public void put(Variable var, Object value) {super.put(var.Name,value);}

    public Object get(Variable var) {return super.get(var.Name);}

    // Typed gets

    public Object eval(Variable var) {return eval(var.Name);}

    public Object eval(String var)
    {
	Object o = this.get(var);
	if(o != null && (o instanceof Function)) o = ((Function)o).get(this);
	return o;
    }

    public int getInt(Variable var) {return this.getInt(var,-1);}

    public int getInt(Variable var, int dfalt) {return getInt(var.Name,dfalt);}

    public int getInt(String var, int dfalt)
    {
	Object o = this.eval(var);
	if(o == null) return dfalt;
	if(o instanceof Number) return ((Number)o).intValue();
	if(o instanceof Boolean) return ((Boolean)o).booleanValue()?1:0;
	if(o instanceof String) return Integer.parseInt((String)o);
	return dfalt;
    }

    public String getString(Variable var) {return this.getString(var,null);}

    public String getString(Variable var, String dfalt)
	{return getString(var.Name,dfalt);}

    public String getString(String var, String dfalt)
    {
	Object o = this.eval(var);
	if(o == null) return dfalt;
	return String.valueOf(o);
    }

    public boolean getBoolean(Variable var)
        {return this.getBoolean(var,false);}

    public boolean getBoolean(Variable var, boolean dfalt)
	{return getBoolean(var.Name,dfalt);}

    public boolean getBoolean(String var, boolean dfalt)
    {
	Object o = this.eval(var);
	if(o == null) return dfalt;
	if(o instanceof Boolean) return ((Boolean)o).booleanValue();
	if(o instanceof Number) return ((Number)o).intValue()==0?false:true;
	if(o instanceof String) return Boolean.parseBoolean((String)o);
	return dfalt;
    }

    // Pattern dfalt is always null
    public Pattern getPattern(Variable var) {return getPattern(var.Name);}

    public Pattern getPattern(String var)
    {
	Object o = this.eval(var);
	if(o == null || !(o instanceof Pattern)) return null;
	return (Pattern)o;
    }

    // Provide a special put that checks for target being
    // a collection

    public void setMultiple(Variable var, Object value)
	{setMultiple(var.Name,value);}

    public void setMultiple(String var, Object value)
    {
	if(value == null) return;
	Object target = this.get(var);
	if(target instanceof Collection) {
	    // add value to collection
	    ((Collection)target).add(value);
	} else // just replace
	    this.put(var,value);
    }

    public String toString()
    {
        String s = "{";
	boolean first = true;
	for(Iterator it=keySet().iterator();it.hasNext();first=false) {
	    String key = (String)it.next();
	    s += (first?"":" ");
	    s += (key+"=");
	    Object o = super.get(key);
	    if(o instanceof Function) {
		s += o.toString();
	    } else if(o instanceof Collection) {
	        s += "[";
		boolean one = true;
	        for(Object x : ((Collection)o)) {
		    s += (one?"":" ");
		    s += x.toString();
		    one = false;
		}
	        s += "]";
	    } else {
	        s += ("|"+o+"|");
	    }
	}
	s += "}";
        return s;
    }

    public String prettyPrint()
    {
        String s = "";
	for(Iterator it=keySet().iterator();it.hasNext();) {
	    String key = (String)it.next();
	    s += (key+"=");
	    Object o = super.get(key);
	    if(o instanceof Function) {
		s += o.toString();
	    } else if(o instanceof Collection) {
	        s += "[";
		boolean one = true;
	        for(Object x : ((Collection)o)) {
		    s += (one?"":" ");
		    s += x.toString();
		    one = false;
		}
	        s += "]";
	    } else {
	        s += ("|"+o+"|");
	    }
	    s += "\n";
	}
        return s;
    }
}
