package jpattern.test;

import jpattern.pattern.Pattern;
import jpattern.pattern.VarMap;
import jpattern.pattern.Function;
import jpattern.pattern.PatternBuilder;
import jpattern.pattern.Variable;

public class Test5 implements PatternBuilder
{
    public VarMap buildPattern() {return makePattern();}

    static VarMap vars = new VarMap();
    static Pattern Digs = null;
    static Pattern Find = null;
    static Function GTS = null;

    static VarMap makePattern()
    {
	System.out.println("Example 5");
	GTS = new Function() {
		public Object get(VarMap vars)
	        {
	            String Cur = vars.getString("Cur","");
	            String Max = vars.getString("Max","");
	            return Boolean.valueOf(Cur.length() > Max.length());
	        }
		public String toString() {return "GTS";}
	};
	vars.put("GTS",GTS);
	vars.put("Digit","0123456789");
	Find = @""*Max fence           // initialize Max to null \
                & breakx(+Digit)       // scan looking for digits \
                & ((span(+Digit)*Cur   // assign next string to Cur \
	            & (+GTS)           // check size(Cur) > Size(Max) \
                    & setcur(+Loc))    // if so, save location \
                   * Max)              // and assign to Max \
                & fail                 // seek all alternatives \
		@;
	Digs = @span(+Digit)@;
	vars.put("Digs",Digs);
	vars.put("Find",Find);
	return vars;
    }
}
/*
	Find = 
		@""*Max & fence \
                 & breakx(+Digit) \
                 & ((span(+Digit)*Cur \
	             & (+GTS) \
                     & setcur(+Loc)) \
                    * Max) \
                 & fail;@
*/
